Attribute VB_Name = "Module3"
'**********************************************************
' Enum Constant Value
'**********************************************************



'' SOUNCARD FUNCTIONS ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
'' 
Public Declare Function QCAP_SOUNDCARD_ENUMERATION Lib "QCAP.X86.DLL" (ByRef ppszSoundCardDevName As String, ByVal bNext  As Boolean ) As ResultOfFunction 
'
Public Declare Function QCAP_SOUNDCARD_ENUMERATION_W Lib "QCAP.X86.DLL" QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SOUNDCARD_ENUMERATION_W( WSTRING * ppwszSoundCardDevName , BOOL bNext = FALSE  ); ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_DEFAULT_SOUNDCARD Lib "QCAP.X86.DLL" (ByVal pszMicrophoneDevName As String, ByVal pszLineInDevName   As String ) As ResultOfFunction 
'
'' SOUNCARD EXAMPLE:
'' 
'' STEP#01 QCAP_CREATE( "SOUNDCARD", 0, hWindow, &pDevice, TRUE );
'' 
'' STEP#02 QCAP_SET_AUDIO_INPUT( pDevice, QCAP_INPUT_TYPE_SOUNDCARD_LINE_IN );
'' 
'' STEP#03 QCAP_RUN( pDevice );
'' 
'' STEP#04 QCAP_STOP( pDevice );
'' 
'' STEP#05 QCAP_DESTROY( pDevice );
'
'' COMMUNICATION SERVER FUNCTIONS ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
''
'typedef QRETURN (QCAP_EXPORT *PF_COMMUNICATION_SERVER_GET_CUSTOM_PROPERTY_CALLBACK)( PVOID pServer , CHAR * pszProperty , CHAR * pszValue , PVOID pUserData  );
'
'typedef QRETURN (QCAP_EXPORT *PF_COMMUNICATION_SERVER_SET_CUSTOM_PROPERTY_CALLBACK)( PVOID pServer , CHAR * pszProperty , CHAR * pszValue , PVOID pUserData  );
'
'typedef QRETURN (QCAP_EXPORT *PF_COMMUNICATION_SERVER_PROFILE_VIDEO_SETUP_CALLBACK)( PVOID pServer , UINT iProNum , ULONG nEncoderFormat , ULONG nWidth , ULONG nHeight , ULONG nFrameRate , ULONG nRecordMode , ULONG nQuality , ULONG nBitRate , ULONG nGOP , PVOID pUserData  );
'
'typedef QRETURN (QCAP_EXPORT *PF_COMMUNICATION_SERVER_PROFILE_AUDIO_SETUP_CALLBACK)( PVOID pServer , UINT iProNum , ULONG nEncoderFormat , ULONG nChannels , ULONG nBitsPerSample , ULONG nSampleFrequency , ULONG nBitRate , PVOID pUserData  );
'
Public Declare Function QCAP_CREATE_COMMUNICATION_ONVIF_SERVER Lib "QCAP.X86.DLL" (ByVal nTotalVideoSources As Long, ByVal nTotalAudioSources As Long, ByVal nTotalVideoEncoders As Long, ByVal nTotalAudioEncoders As Long, ByVal nTotalProfiles As Long, ByRef ppServer As Long, ByVal pszName As String, ByVal pszLocation As String, ByVal pszManufacturer As String, ByVal pszModel As String, ByVal pszHardwareVersion As String, ByVal pszFirmwareVersion As String, ByVal pszDeviceID As String, ByVal pszRootAccount As String, ByVal pszRootPassword  As String ) As ResultOfFunction 
'
Public Declare Function QCAP_DESTROY_COMMUNICATION_SERVER Lib "QCAP.X86.DLL" (ByVal pServer   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_START_COMMUNICATION_SERVER Lib "QCAP.X86.DLL" (ByVal pServer As Long, ByVal nNetworkPort  As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_STOP_COMMUNICATION_SERVER Lib "QCAP.X86.DLL" (ByVal pServer   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_GET_COMMUNICATION_SERVER_VIDEO_SOURCE Lib "QCAP.X86.DLL" (ByVal pServer As Long, ByVal iVidSrcNum As Long, ByRef pWidth As Long, ByRef pHeight As Long, ByRef pFrameRate   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_COMMUNICATION_SERVER_VIDEO_SOURCE Lib "QCAP.X86.DLL" (ByVal pServer As Long, ByVal iVidSrcNum As Long, ByVal   nWidth As Long, ByVal   nHeight As Long, ByVal   nFrameRate    As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_GET_COMMUNICATION_SERVER_AUDIO_SOURCE Lib "QCAP.X86.DLL" (ByVal pServer As Long, ByVal iAudSrcNum As Long, ByRef pChannels As Long, ByRef pBitsPerSample As Long, ByRef pSampleFrequency   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_COMMUNICATION_SERVER_AUDIO_SOURCE Lib "QCAP.X86.DLL" (ByVal pServer As Long, ByVal iAudSrcNum As Long, ByVal   nChannels As Long, ByVal   nBitsPerSample As Long, ByVal   nSampleFrequency    As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_GET_COMMUNICATION_SERVER_VIDEO_ENCODER Lib "QCAP.X86.DLL" _
(ByVal pServer As Long, ByVal iVidEncNum As Long, ByRef pEncoderFormat As Long, ByRef pWidth As Long, ByRef pHeight As Long, ByRef pFrameRate_Min As Long, ByRef pFrameRate_Max As Long, ByRef pFrameRate_Default As Long, ByRef pRecordMode_Min As Long, ByRef pRecordMode_Max As Long, ByRef pRecordMode_Default As Long, ByRef pQuality_Min As Long, ByRef pQuality_Max As Long, ByRef pQuality_Default As Long, ByRef pBitRate_Min As Long, ByRef pBitRate_Max As Long, ByRef pBitRate_Default As Long, ByRef pGOP_Min As Long _
, ByRef pGOP_Max As Long, ByRef pGOP_Default   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_COMMUNICATION_SERVER_VIDEO_ENCODER Lib "QCAP.X86.DLL" _
(ByVal pServer As Long, ByVal iVidEncNum As Long, ByVal   nEncoderFormat As Long, ByVal   nWidth As Long, ByVal   nHeight As Long, ByVal   nFrameRate_Min As Long, ByVal   nFrameRate_Max As Long, ByVal   nFrameRate_Default As Long, ByVal   nRecordMode_Min As Long, ByVal   nRecordMode_Max As Long, ByVal   nRecordMode_Default As Long, ByVal   nQuality_Min As Long, ByVal   nQuality_Max As Long, ByVal   nQuality_Default As Long, ByVal   nBitRate_Min As Long, ByVal   nBitRate_Max As Long, ByVal   nBitRate_Default As Long _
, ByVal   nGOP_Min As Long, ByVal   nGOP_Max As Long, ByVal   nGOP_Default    As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_GET_COMMUNICATION_SERVER_AUDIO_ENCODER Lib "QCAP.X86.DLL" (ByVal pServer As Long, ByVal iAudEncNum As Long, ByRef pEncoderFormat As Long, ByRef pChannels As Long, ByRef pBitsPerSample As Long, ByRef pSampleFrequency As Long, ByRef pBitRate_Min As Long, ByRef pBitRate_Max As Long, ByRef pBitRate_Default   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_COMMUNICATION_SERVER_AUDIO_ENCODER Lib "QCAP.X86.DLL" (ByVal pServer As Long, ByVal iAudEncNum As Long, ByVal   nEncoderFormat As Long, ByVal   nChannels As Long, ByVal   nBitsPerSample As Long, ByVal   nSampleFrequency As Long, ByVal   nBitRate_Min As Long, ByVal   nBitRate_Max As Long, ByVal   nBitRate_Default    As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_GET_COMMUNICATION_SERVER_PROFILE Lib "QCAP.X86.DLL" (ByVal pServer As Long, ByVal iProNum As Long, ByRef ppszURL As String, ByRef pVidSrcNum As Long, ByRef pAudSrcNum As Long, ByRef pVidEncNum As Long, ByRef pAudEncNum   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_COMMUNICATION_SERVER_PROFILE Lib "QCAP.X86.DLL" (ByVal pServer As Long, ByVal iProNum As Long, ByVal   pszURL As String, ByVal   iVidSrcNum As Long, ByVal   iAudSrcNum As Long, ByVal   iVidEncNum As Long, ByVal   iAudEncNum    As Long ) As ResultOfFunction 
'
'QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_COMMUNICATION_SERVER_GET_CUSTOM_PROPERTY_CALLBACK( PVOID pServer , PF_COMMUNICATION_SERVER_GET_CUSTOM_PROPERTY_CALLBACK pCB , PVOID pUserData  );
'
'QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_COMMUNICATION_SERVER_SET_CUSTOM_PROPERTY_CALLBACK( PVOID pServer , PF_COMMUNICATION_SERVER_SET_CUSTOM_PROPERTY_CALLBACK pCB , PVOID pUserData  );
'
'QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_COMMUNICATION_SERVER_PROFILE_VIDEO_SETUP_CALLBACK( PVOID pServer , PF_COMMUNICATION_SERVER_PROFILE_VIDEO_SETUP_CALLBACK pCB , PVOID pUserData  );
'
'QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_COMMUNICATION_SERVER_PROFILE_AUDIO_SETUP_CALLBACK( PVOID pServer , PF_COMMUNICATION_SERVER_PROFILE_AUDIO_SETUP_CALLBACK pCB , PVOID pUserData  );
'
'' COMMUNICATION EMULATOR FUNCTIONS /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
''
'typedef QRETURN (QCAP_EXPORT *PF_COMMUNICATION_EMULATOR_SCAN_DONE_CALLBACK)( PVOID pEmulator , ULONG nTotalServers , PVOID pUserData  );
'
Public Declare Function QCAP_CREATE_COMMUNICATION_ONVIF_EMULATOR Lib "QCAP.X86.DLL" (ByRef ppEmulator   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_DESTROY_COMMUNICATION_EMULATOR Lib "QCAP.X86.DLL" (ByVal pEmulator   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_START_COMMUNICATION_EMULATOR Lib "QCAP.X86.DLL" (ByVal pEmulator   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_STOP_COMMUNICATION_EMULATOR Lib "QCAP.X86.DLL" (ByVal pEmulator   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_GET_COMMUNICATION_EMULATOR_SERVER_INFO Lib "QCAP.X86.DLL" (ByVal pEmulator As Long, ByVal iSvrNum As Long, ByRef ppszNetworkIP As String, ByRef pNetworkPort As Long, ByRef ppszNetworkURL   As String ) As ResultOfFunction 
'
'QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_COMMUNICATION_EMULATOR_SCAN_DONE_CALLBACK( PVOID pEmulator , PF_COMMUNICATION_EMULATOR_SCAN_DONE_CALLBACK pCB , PVOID pUserData  );
'
'' COMMUNICATION CLIENT FUNCTIONS ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
''
'typedef QRETURN (QCAP_EXPORT *PF_COMMUNICATION_CLIENT_CONNECTED_CALLBACK)( PVOID pClient , ULONG nTotalVideoSources , ULONG nTotalAudioSources , ULONG nTotalVideoEncoders , ULONG nTotalAudioEncoders , ULONG nTotalProfiles , CHAR * pszName , CHAR * pszLocationr , CHAR * pszManufacturer , CHAR * pszModel , CHAR * pszHardwareVersion , CHAR * pszFirmwareVersion , CHAR * pszDeviceID , PVOID pUserData  );
'
Public Declare Function QCAP_CREATE_COMMUNICATION_ONVIF_CLIENT Lib "QCAP.X86.DLL" (ByVal pszNetworkURL As String, ByRef ppClient As Long, ByVal pszAccount As String, ByVal pszPassword  As String ) As ResultOfFunction 
'
Public Declare Function QCAP_DESTROY_COMMUNICATION_CLIENT Lib "QCAP.X86.DLL" (ByVal pClient   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_START_COMMUNICATION_CLIENT Lib "QCAP.X86.DLL" (ByVal pClient   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_STOP_COMMUNICATION_CLIENT Lib "QCAP.X86.DLL" (ByVal pClient   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_GET_COMMUNICATION_CLIENT_VIDEO_SOURCE_INFO Lib "QCAP.X86.DLL" (ByVal pClient As Long, ByVal iVidSrcNum As Long, ByRef pWidth As Long, ByRef pHeight As Long, ByRef pFrameRate   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_GET_COMMUNICATION_CLIENT_AUDIO_SOURCE_INFO Lib "QCAP.X86.DLL" (ByVal pClient As Long, ByVal iAudSrcNum As Long, ByRef pChannels As Long, ByRef pBitsPerSample As Long, ByRef pSampleFrequency   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_GET_COMMUNICATION_CLIENT_VIDEO_ENCODER_INFO Lib "QCAP.X86.DLL" (ByVal pClient As Long, ByVal iVidEncNum As Long, ByRef pTotalVidEncOptions As Long, ByRef pVidEncOptionNum_Default   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_GET_COMMUNICATION_CLIENT_AUDIO_ENCODER_INFO Lib "QCAP.X86.DLL" (ByVal pClient As Long, ByVal iAudEncNum As Long, ByRef pTotalAudEncOptions As Long, ByRef pAudEncOptionNum_Default   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_GET_COMMUNICATION_CLIENT_VIDEO_ENCODER_OPTION_INFO Lib "QCAP.X86.DLL" _
(ByVal pClient As Long, ByVal iVidEncNum As Long, ByVal iVidEncOptionNum As Long, ByRef pEncoderFormat As Long, ByRef pWidthList As Long, ByRef pWidthListSize As Long, ByRef pWidth_Default As Long, ByRef pHeightList As Long, ByRef pHeightListSize As Long, ByRef pHeight_Default As Long, ByRef pFrameRate_Min As Long, ByRef pFrameRate_Max As Long, ByRef pFrameRate_Default As Long, ByRef pRecordMode_Min As Long, ByRef pRecordMode_Max As Long, ByRef pRecordMode_Default As Long, ByRef pQuality_Min As Long _
, ByRef pQuality_Max As Long, ByRef pQuality_Default As Long, ByRef pBitRate_Min As Long, ByRef pBitRate_Max As Long, ByRef pBitRate_Default As Long, ByRef pGOP_Min As Long, ByRef pGOP_Max As Long, ByRef pGOP_Default   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_GET_COMMUNICATION_CLIENT_AUDIO_ENCODER_OPTION_INFO Lib "QCAP.X86.DLL" _
(ByVal pClient As Long, ByVal iAudEncNum As Long, ByVal iAudEncOptionNum As Long, ByRef pEncoderFormat As Long, ByRef pChannelsList As Long, ByRef pChannelsListSize As Long, ByRef pChannels_Default As Long, ByRef pBitsPerSampleList As Long, ByRef pBitsPerSampleListSize As Long, ByRef pBitsPerSample_Default As Long, ByRef pSampleFrequencyList As Long, ByRef pSampleFrequencyListSize As Long, ByRef pSampleFrequency_Default As Long, ByRef pBitRate_Min As Long, ByRef pBitRate_Max As Long, ByRef pBitRate_Default   As Long _
 ) As ResultOfFunction 
'
Public Declare Function QCAP_GET_COMMUNICATION_CLIENT_PROFILE_INFO Lib "QCAP.X86.DLL" (ByVal pClient As Long, ByVal iProNum As Long, ByRef ppszURL As String, ByRef pVidSrcNum As Long, ByRef pAudSrcNum As Long, ByRef pVidEncNum As Long, ByRef pAudEncNum   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_GET_COMMUNICATION_CLIENT_PROFILE_VIDEO_PROPERTY Lib "QCAP.X86.DLL" (ByVal pClient As Long, ByVal iProNum As Long, ByRef pEncoderFormat As Long, ByRef pWidth As Long, ByRef pHeight As Long, ByRef pFrameRate As Long, ByRef pRecordMode As Long, ByRef pQuality As Long, ByRef pBitRate As Long, ByRef pGOP   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_COMMUNICATION_CLIENT_PROFILE_VIDEO_PROPERTY Lib "QCAP.X86.DLL" (ByVal pClient As Long, ByVal iProNum As Long, ByVal   nEncoderFormat As Long, ByVal   nWidth As Long, ByVal   nHeight As Long, ByVal   nFrameRate As Long, ByVal   nRecordMode As Long, ByVal   nQuality As Long, ByVal   nBitRate As Long, ByVal   nGOP    As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_GET_COMMUNICATION_CLIENT_PROFILE_AUDIO_PROPERTY Lib "QCAP.X86.DLL" (ByVal pClient As Long, ByVal iProNum As Long, ByRef pEncoderFormat As Long, ByRef pChannels As Long, ByRef pBitsPerSample As Long, ByRef pSampleFrequency As Long, ByRef pBitRate   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_COMMUNICATION_CLIENT_PROFILE_AUDIO_PROPERTY Lib "QCAP.X86.DLL" (ByVal pClient As Long, ByVal iProNum As Long, ByVal   nEncoderFormat As Long, ByVal   nChannels As Long, ByVal   nBitsPerSample As Long, ByVal   nSampleFrequency As Long, ByVal   nBitRate    As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_GET_COMMUNICATION_CLIENT_CUSTOM_PROPERTY Lib "QCAP.X86.DLL" (ByVal pClient As Long, ByVal pszProperty As String, ByRef ppszValue   As String ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_COMMUNICATION_CLIENT_CUSTOM_PROPERTY Lib "QCAP.X86.DLL" (ByVal pClient As Long, ByVal pszProperty As String, ByVal pszValue   As String ) As ResultOfFunction 
'
'QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_COMMUNICATION_CLIENT_CONNECTED_CALLBACK( PVOID pClient , PF_COMMUNICATION_CLIENT_CONNECTED_CALLBACK pCB , PVOID pUserData  );
'
'' ##########################################################################################################################################################################################
'' #
'' # WEBRTC FUNCTIONS (CHATROOM)
'' #
'' ##########################################################################################################################################################################################
''
Public Declare Function QCAP_CREATE_WEBRTC_CHATROOM Lib "QCAP.X86.DLL" (ByVal nNetworkPort As Long, ByRef ppChatRoom   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_DESTROY_WEBRTC_CHATROOM Lib "QCAP.X86.DLL" (ByVal pChatRoom   As Long ) As ResultOfFunction 
'
'' ##########################################################################################################################################################################################
'' #
'' # WEBRTC FUNCTIONS (P2P)
'' #
'' ##########################################################################################################################################################################################
''
'typedef QRETURN (QCAP_EXPORT *PF_WEBRTC_CHATROOM_LOGIN_CALLBACK)( PVOID pChatter , ULONG nPeerID , CHAR * pszPeerUserName , PVOID pUserData  );
'
'typedef QRETURN (QCAP_EXPORT *PF_WEBRTC_CHATROOM_LOGOUT_CALLBACK)( PVOID pChatter , ULONG nPeerID , PVOID pUserData  );
'
'typedef QRETURN (QCAP_EXPORT *PF_WEBRTC_PRIVATE_SDP_PROPERTY_CALLBACK)( PVOID pChatter , ULONG nPeerID , CHAR * pszType , CHAR * pszSDP , PVOID pUserData  );
'
'typedef QRETURN (QCAP_EXPORT *PF_WEBRTC_PEER_CONNECTED_CALLBACK)( PVOID pChatter , ULONG nPeerID , QRESULT nConnectionStatus , PVOID pUserData  );
'
'typedef QRETURN (QCAP_EXPORT *PF_WEBRTC_PEER_DISCONNECTED_CALLBACK)( PVOID pChatter , ULONG nPeerID , PVOID pUserData  );
'
'typedef QRETURN(QCAP_EXPORT *PF_WEBRTC_SEND_DATA_DONE_CALLBACK)( PVOID pChatter , ULONG nPeerID , QRESULT nSendStatus , PVOID pUserData  );
'
'typedef QRETURN(QCAP_EXPORT *PF_WEBRTC_SEND_FILE_DONE_CALLBACK)( PVOID pChatter , ULONG nPeerID , QRESULT nSendStatus , PVOID pUserData  );
'
'typedef QRETURN(QCAP_EXPORT *PF_WEBRTC_RECEIVED_DATA_DONE_CALLBACK)( PVOID pChatter , ULONG nPeerID , CHAR * pszData , ULONG nDataSize , PVOID pUserData  );
'
'typedef QRETURN(QCAP_EXPORT *PF_WEBRTC_RECEIVED_FILE_DONE_CALLBACK)( PVOID pChatter , ULONG nPeerID , CHAR * pszFileNamePath , PVOID pUserData  );
'
'typedef QRETURN(QCAP_EXPORT *PF_WEBRTC_RECEIVED_FILE_STATUS_CALLBACK)( PVOID pChatter , ULONG nPeerID , ULONG nRecvSize , ULONG nTotalSize , PVOID pUserData  );
'
'typedef QRETURN(QCAP_EXPORT *PF_WEBRTC_NETWORK_QOS_STATUS_CALLBACK)( PVOID pChatter , ULONG nExpectedBitRate , ULONG nExpectedFrameRate , PVOID pUserData  );
'
Public Declare Function QCAP_CREATE_WEBRTC_CHATTER Lib "QCAP.X86.DLL" (ByVal pszChatRoomLoginIP As String, ByVal nChatRoomLoginPort As Long, ByVal pszUserName As String, ByRef ppChatter As Long, ByVal  * pLoginID As Long, ByVal nConnectionTimeout As Long, ByVal pszStunURL As String, ByVal pszReceivedFileFolderPath  As String ) As ResultOfFunction 
'
Public Declare Function QCAP_DESTROY_WEBRTC_CHATTER Lib "QCAP.X86.DLL" (ByVal pChatter   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_START_WEBRTC_CHAT Lib "QCAP.X86.DLL" (ByVal pChatter As Long, ByVal nPeerID   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_STOP_WEBRTC_CHAT Lib "QCAP.X86.DLL" (ByVal pChatter   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_CREATE_WEBRTC_SENDER Lib "QCAP.X86.DLL" (ByVal pChatter As Long, ByVal iSvrNum  As Long, ByRef ppServer   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_CREATE_WEBRTC_RECEIVER Lib "QCAP.X86.DLL" (ByVal pChatter As Long, ByVal iCliNum  As Long, ByRef ppClient As Long, ByVal nDecoderType As Long, ByVal hAttachedWindow As Long, ByVal bThumbDraw As Boolean, ByVal bMaintainAspectRatio  As Boolean ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_WEBRTC_PRIVATE_SDP_PROPERTY Lib "QCAP.X86.DLL" (ByVal pChatter As Long, ByVal nPeerID As Long, ByVal pszSDP   As String ) As ResultOfFunction 
'
Public Declare Function QCAP_ENUM_WEBRTC_USER_IN_CHATROOM Lib "QCAP.X86.DLL" (ByVal pChatter As Long, ByRef pPeerID As Long, ByRef ppszPeerUserName As String, ByVal bNext  As Boolean ) As ResultOfFunction 
'
Public Declare Function QCAP_SEND_WEBRTC_DATA Lib "QCAP.X86.DLL" (ByVal pChatter As Long, ByVal pszData   As String ) As ResultOfFunction 
'
Public Declare Function QCAP_SEND_WEBRTC_FILE Lib "QCAP.X86.DLL" (ByVal pChatter As Long, ByVal pszFilePathName   As String ) As ResultOfFunction 
'
'QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_WEBRTC_CHATROOM_LOGIN_CALLBACK( PVOID pChatter , PF_WEBRTC_CHATROOM_LOGIN_CALLBACK pCB , PVOID pUserData  );
'
'QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_WEBRTC_CHATROOM_LOGOUT_CALLBACK( PVOID pChatter , PF_WEBRTC_CHATROOM_LOGOUT_CALLBACK pCB , PVOID pUserData  );
'
'QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_WEBRTC_PRIVATE_SDP_PROPERTY_CALLBACK( PVOID pChatter , PF_WEBRTC_PRIVATE_SDP_PROPERTY_CALLBACK pCB , PVOID pUserData  );
'
'QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_WEBRTC_PEER_CONNECTED_CALLBACK( PVOID pChatter , PF_WEBRTC_PEER_CONNECTED_CALLBACK pCB , PVOID pUserData  );
'
'QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_WEBRTC_PEER_DISCONNECTED_CALLBACK( PVOID pChatter , PF_WEBRTC_PEER_DISCONNECTED_CALLBACK pCB , PVOID pUserData  );
'
'QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_WEBRTC_SEND_DATA_DONE_CALLBACK( PVOID pChatter , PF_WEBRTC_SEND_DATA_DONE_CALLBACK pCB , PVOID pUserData  );
'
'QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_WEBRTC_SEND_FILE_DONE_CALLBACK( PVOID pChatter , PF_WEBRTC_SEND_FILE_DONE_CALLBACK pCB , PVOID pUserData  );
'
'QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_WEBRTC_RECEIVED_DATA_DONE_CALLBACK( PVOID pChatter , PF_WEBRTC_RECEIVED_DATA_DONE_CALLBACK pCB , PVOID pUserData  );
'
'QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_WEBRTC_RECEIVED_FILE_DONE_CALLBACK( PVOID pChatter , PF_WEBRTC_RECEIVED_FILE_DONE_CALLBACK pCB , PVOID pUserData  );
'
'QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_WEBRTC_RECEIVED_FILE_STATUS_CALLBACK( PVOID pChatter , PF_WEBRTC_RECEIVED_FILE_STATUS_CALLBACK pCB , PVOID pUserData  );
'
'QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_WEBRTC_NETWORK_QOS_STATUS_CALLBACK( PVOID pChatter , PF_WEBRTC_NETWORK_QOS_STATUS_CALLBACK pCB , PVOID pUserData  );
'
'' ##########################################################################################################################################################################################
'' #
'' # FILE PLAYBACK FUNCTIONS (PLAYBACK/EDITING/REPAIR/FILE)
'' #
'' ##########################################################################################################################################################################################
''
'' FILE PLAYBACK FUNCTIONS //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
'' 
'typedef QRETURN (QCAP_EXPORT *PF_FILE_SNAPSHOT_DONE_CALLBACK)( PVOID pFile , CHAR * pszFilePathName , PVOID pUserData  );
'
'typedef QRETURN (QCAP_EXPORT *PF_FILE_SNAPSHOT_STREAM_CALLBACK)( PVOID pFile , CHAR * pszFilePathName , BYTE * pStreamBuffer , ULONG nStreamBufferLen , PVOID pUserData  );
'
'typedef QRETURN (QCAP_EXPORT *PF_VIDEO_DECODER_FILE_CALLBACK)( PVOID pFile , double dSampleTime , BYTE * pFrameBuffer , ULONG nFrameBufferLen , PVOID pUserData  );
'
'typedef QRETURN (QCAP_EXPORT *PF_AUDIO_DECODER_FILE_CALLBACK)( PVOID pFile , double dSampleTime , BYTE * pFrameBuffer , ULONG nFrameBufferLen , PVOID pUserData  );
'
'typedef QRETURN (QCAP_EXPORT *PF_VIDEO_DECODER_FILE_CALLBACK_EX)( PVOID pFile , UINT iFrameNum , double dSampleTime , BYTE * pFrameBuffer , ULONG nFrameBufferLen , PVOID pUserData  ); ' ONLY FOR QCAP_OPEN_FILE_EX & QCAP_OPEN_TIMESHIFT_FILE_EX
'
'typedef QRETURN (QCAP_EXPORT *PF_AUDIO_DECODER_FILE_CALLBACK_EX)( PVOID pFile , UINT iFrameNum , double dSampleTime , BYTE * pFrameBuffer , ULONG nFrameBufferLen , PVOID pUserData  ); ' ONLY FOR QCAP_OPEN_FILE_EX & QCAP_OPEN_TIMESHIFT_FILE_EX
'
'typedef QRETURN (QCAP_EXPORT *PF_VIDEO_DECODER_3D_FILE_CALLBACK)( PVOID pFile , UINT iChNum , double dSampleTime , BYTE * pFrameBuffer , ULONG nFrameBufferLen , PVOID pUserData  );
'
Public Declare Function  QCAP_OPEN_FILE Lib "QCAP.X86.DLL" _
(ByVal pszFileName As String, ByRef ppFile As Long, ByVal nDecoderType As Long, ByRef pVideoEncoderFormat As Long, ByRef pVideoWidth As Long, ByRef pVideoHeight As Long, ByRef pVideoFrameRate As Double, ByRef pAudioEncoderFormat As Long, ByRef pAudioChannels As Long, ByRef pAudioBitsPerSample As Long, ByRef pAudioSampleFrequency As Long, ByRef pTotalDurationTimes As Double, ByRef pTotalVideoFrames As Long, ByRef pTotalAudioFrames As Long, ByRef pTotalMetadataFrames As Long, ByVal hAttachedWindow As Long _
, ByVal bThumbDraw As Boolean, ByVal bMaintainAspectRatio As Boolean, ByVal bEnableEditFunction  As Boolean ) As ResultOfFunction 
'
Public Declare Function  QCAP_OPEN_FILE_EX Lib "QCAP.X86.DLL" _
(ByVal pszFileName As String, ByRef ppFile As Long, ByVal nDecoderType As Long, ByRef pVideoEncoderFormat As Long, ByRef pVideoWidth As Long, ByRef pVideoHeight As Long, ByRef pVideoFrameRate As Double, ByRef pAudioEncoderFormat As Long, ByRef pAudioChannels As Long, ByRef pAudioBitsPerSample As Long, ByRef pAudioSampleFrequency As Long, ByRef pTotalDurationTimes As Double, ByRef pTotalVideoFrames As Long, ByRef pTotalAudioFrames As Long, ByRef pTotalMetadataFrames As Long, ByVal hAttachedWindow As Long _
, ByVal bThumbDraw As Boolean, ByVal bMaintainAspectRatio  As Boolean ) As ResultOfFunction 
'
Public Declare Function  QCAP_OPEN_3D_FILE Lib "QCAP.X86.DLL" _
(ByVal pszFileName As String, ByRef ppFile As Long, ByRef pIs3D As Boolean, ByVal nDecoderType As Long, ByRef pVideoEncoderFormat As Long, ByRef pVideoWidth As Long, ByRef pVideoHeight As Long, ByRef pVideoFrameRate As Double, ByRef pAudioEncoderFormat As Long, ByRef pAudioChannels As Long, ByRef pAudioBitsPerSample As Long, ByRef pAudioSampleFrequency As Long, ByRef pTotalDurationTimes As Double, ByRef pTotalVideoFrames As Long, ByRef pTotalAudioFrames As Long, ByRef pTotalMetadataFrames As Long _
, ByVal hAttachedWindowL As Long, ByVal bThumbDrawL As Boolean, ByVal bMaintainAspectRatioL As Boolean, ByVal hAttachedWindowR As Long, ByVal bThumbDrawR As Boolean, ByVal bMaintainAspectRatioR As Boolean, ByVal bEnableEditFunction  As Boolean ) As ResultOfFunction 
'
Public Declare Function  QCAP_OPEN_TIMESHIFT_FILE_EX Lib "QCAP.X86.DLL" _
(ByVal pPhysicalFileWriter As Long, ByRef ppFile As Long, ByVal nDecoderType As Long, ByRef pVideoEncoderFormat As Long, ByRef pVideoWidth As Long, ByRef pVideoHeight As Long, ByRef pVideoFrameRate As Double, ByRef pAudioEncoderFormat As Long, ByRef pAudioChannels As Long, ByRef pAudioBitsPerSample As Long, ByRef pAudioSampleFrequency As Long, ByRef pTotalDurationTimes As Double, ByRef pTotalVideoFrames As Long, ByRef pTotalAudioFrames As Long, ByRef pTotalMetadataFrames As Long, ByVal hAttachedWindow As Long _
, ByVal bThumbDraw As Boolean, ByVal bMaintainAspectRatio  As Boolean ) As ResultOfFunction 
'
Public Declare Function  QCAP_OPEN_SCF_FILE Lib "QCAP.X86.DLL" (ByVal iChNum As Long, ByRef ppFile As Long, ByVal nDecoderType As Long, ByVal hAttachedWindow As Long, ByVal bThumbDraw As Boolean, ByVal bMaintainAspectRatio As Boolean, ByVal dStartSampleTime As Double, ByVal dStopSampleTime  As Double ) As ResultOfFunction 
'
Public Declare Function  QCAP_DESTROY_FILE Lib "QCAP.X86.DLL" (ByVal pFile   As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_PLAY_FILE Lib "QCAP.X86.DLL" (ByVal pFile   As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_PAUSE_FILE Lib "QCAP.X86.DLL" (ByVal pFile   As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_STOP_FILE Lib "QCAP.X86.DLL" (ByVal pFile   As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_PLAY_GLOBAL_SCF_FILE Lib "QCAP.X86.DLL" () As ResultOfFunction 
'
Public Declare Function  QCAP_PAUSE_GLOBAL_SCF_FILE Lib "QCAP.X86.DLL" () As ResultOfFunction 
'
Public Declare Function  QCAP_STOP_GLOBAL_SCF_FILE Lib "QCAP.X86.DLL" () As ResultOfFunction 
'
Public Declare Function  QCAP_REFRESH_TIMESHIFT_FILE_INFO Lib "QCAP.X86.DLL" (ByVal pFile As Long, ByRef pTotalDurationTimes As Double, ByRef pTotalVideoFrames As Long, ByRef pTotalAudioFrames As Long, ByRef pTotalMetadataFrames   As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_SCF_FILE_ENUMERATION Lib "QCAP.X86.DLL" _
(ByVal iChNum As Long, ByVal dStartSearchTime As Double, ByVal dStopSearchTime As Double, ByRef pFileSizeHigh As Long, ByRef pFileSizeLow As Long, ByRef pFileStartTime As Double, ByRef pFileStopTime As Double, ByRef pVideoStartTime As Double, ByRef pVideoStopTime As Double, ByRef pAudioStartTime As Double, ByRef pAudioStopTime As Double, ByRef pVideoEncoderFormat As Long, ByRef pVideoWidth As Long, ByRef pVideoHeight As Long, ByRef pVideoFrameRate As Double, ByRef pAudioEncoderFormat As Long, ByRef pAudioChannels As Long _
, ByRef pAudioBitsPerSample As Long, ByRef pAudioSampleFrequency As Long, ByRef pTotalDurationTimes As Double, ByRef pTotalVideoFrames As Long, ByRef pTotalAudioFrames As Long, ByRef pTotalMetadataFrames As Long, ByVal bNext  As Boolean ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_SCF_FILE_TIMER Lib "QCAP.X86.DLL" (ByVal iChNum As Long, ByVal bEnableGlobalTimer   As Boolean ) As ResultOfFunction 
'
Public Declare Function  QCAP_GET_FILE_POSITION Lib "QCAP.X86.DLL" (ByVal pFile As Long, ByRef pSampleTime   As Double ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_FILE_POSITION Lib "QCAP.X86.DLL" (ByVal pFile As Long, ByVal dSampleTime   As Double ) As ResultOfFunction 
'
Public Declare Function  QCAP_GET_FILE_POSITION_EX Lib "QCAP.X86.DLL" (ByVal pFile As Long, ByRef pSampleTime As Double, ByVal nTimeUnit  As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_FILE_POSITION_EX Lib "QCAP.X86.DLL" (ByVal pFile As Long, ByVal dSampleTime As Double, ByVal nTimeUnit  As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_GET_GLOBAL_SCF_FILE_POSITION Lib "QCAP.X86.DLL" (ByRef pSampleTime   As Double ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_GLOBAL_SCF_FILE_POSITION Lib "QCAP.X86.DLL" (ByVal dSampleTime   As Double ) As ResultOfFunction 
'
Public Declare Function  QCAP_GET_FILE_PLAYBACK_SPEED Lib "QCAP.X86.DLL" (ByVal pFile As Long, ByRef pSpeed   As Double ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_FILE_PLAYBACK_SPEED Lib "QCAP.X86.DLL" (ByVal pFile As Long, ByVal dSpeed   As Double ) As ResultOfFunction 
'
Public Declare Function  QCAP_GET_VIDEO_FILE_STREAM_BUFFER Lib "QCAP.X86.DLL" (ByVal pFile As Long, ByVal iFrameNum As Long, ByVal pStreamBuffer As Long, ByRef pStreamBufferLen As Long, ByRef pIsKeyFrame As Boolean, ByRef pSampleTime   As Double ) As ResultOfFunction 
'
Public Declare Function  QCAP_GET_AUDIO_FILE_STREAM_BUFFER Lib "QCAP.X86.DLL" (ByVal pFile As Long, ByVal iFrameNum As Long, ByVal pStreamBuffer As Long, ByRef pStreamBufferLen As Long, ByRef pSampleTime   As Double ) As ResultOfFunction 
'
Public Declare Function  QCAP_GET_METADATA_FILE_DATA_BUFFER Lib "QCAP.X86.DLL" (ByVal pFile As Long, ByVal iFrameNum As Long, ByVal pDataBuffer As Long, ByRef pDataBufferLen As Long, ByRef pSampleTime   As Double ) As ResultOfFunction 
'
Public Declare Function  QCAP_GET_METADATA_FILE_HEADER Lib "QCAP.X86.DLL" (ByVal pFile As Long, ByRef ppszTitle As String, ByRef ppszArtist As String, ByRef ppszComments As String, ByRef ppszGenre As String, ByRef ppszComposer   As String ) As ResultOfFunction 
'
Public Declare Function  QCAP_GET_METADATA_FILE_HEADER_W Lib "QCAP.X86.DLL" (ByVal pFile As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_GET_VIDEO_3D_FILE_DISPLAY_MODE Lib "QCAP.X86.DLL" (ByVal pFile As Long, ByRef pStereoDisplayMode As Long, ByRef pLeftRightSwap   As Boolean ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_VIDEO_3D_FILE_DISPLAY_MODE Lib "QCAP.X86.DLL" (ByVal pFile As Long, ByVal nStereoDisplayMode As Long, ByVal bLeftRightSwap  As Boolean ) As ResultOfFunction 
'
Public Declare Function  QCAP_GET_VIDEO_FILE_REGION_DISPLAY Lib "QCAP.X86.DLL" (ByVal pFile As Long, ByRef pCropX As Long, ByRef pCropY As Long, ByRef pCropW As Long, ByRef pCropH   As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_VIDEO_FILE_REGION_DISPLAY Lib "QCAP.X86.DLL" (ByVal pFile As Long, ByVal nCropX As Long, ByVal nCropY As Long, ByVal nCropW As Long, ByVal nCropH   As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_GET_VIDEO_FILE_MIRROR Lib "QCAP.X86.DLL" (ByVal pFile As Long, ByRef pHorizontalMirror As Boolean, ByRef pVerticalMirror   As Boolean ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_VIDEO_FILE_MIRROR Lib "QCAP.X86.DLL" (ByVal pFile As Long, ByVal bHorizontalMirror As Boolean, ByVal bVerticalMirror   As Boolean ) As ResultOfFunction 
'
Public Declare Function  QCAP_GET_VIDEO_FILE_BRIGHTNESS Lib "QCAP.X86.DLL" (ByVal pFile As Long, ByRef pValue   As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_VIDEO_FILE_BRIGHTNESS Lib "QCAP.X86.DLL" (ByVal pFile As Long, ByVal nValue   As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_GET_VIDEO_FILE_CONTRAST Lib "QCAP.X86.DLL" (ByVal pFile As Long, ByRef pValue   As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_VIDEO_FILE_CONTRAST Lib "QCAP.X86.DLL" (ByVal pFile As Long, ByVal nValue   As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_GET_VIDEO_FILE_HUE Lib "QCAP.X86.DLL" (ByVal pFile As Long, ByRef pValue   As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_VIDEO_FILE_HUE Lib "QCAP.X86.DLL" (ByVal pFile As Long, ByVal nValue   As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_GET_VIDEO_FILE_SATURATION Lib "QCAP.X86.DLL" (ByVal pFile As Long, ByRef pValue   As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_VIDEO_FILE_SATURATION Lib "QCAP.X86.DLL" (ByVal pFile As Long, ByVal nValue   As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_GET_AUDIO_FILE_SOUND_RENDERER Lib "QCAP.X86.DLL" (ByVal pFile As Long, ByRef pSoundNum   As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_AUDIO_FILE_SOUND_RENDERER Lib "QCAP.X86.DLL" (ByVal pFile As Long, ByVal iSoundNum   As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_GET_AUDIO_FILE_VOLUME Lib "QCAP.X86.DLL" (ByVal pFile As Long, ByRef pVolume   As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_AUDIO_FILE_VOLUME Lib "QCAP.X86.DLL" (ByVal pFile As Long, ByVal nVolume   As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_SNAPSHOT_FILE_BMP Lib "QCAP.X86.DLL" (ByVal pFile As Long, ByVal pszFilePathName As String, ByVal bIsAsync As Boolean, ByVal nMilliseconds  As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_SNAPSHOT_FILE_JPG Lib "QCAP.X86.DLL" (ByVal pFile As Long, ByVal pszFilePathName As String, ByVal nQuality As Long, ByVal bIsAsync As Boolean, ByVal nMilliseconds  As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_SNAPSHOT_FILE_BMP_EX Lib "QCAP.X86.DLL" (ByVal pFile As Long, ByVal pszFilePathName As String, ByVal nCropX As Long, ByVal nCropY As Long, ByVal nCropW As Long, ByVal nCropH As Long, ByVal nDstW As Long, ByVal nDstH As Long, ByVal bIsAsync As Boolean, ByVal nMilliseconds  As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_SNAPSHOT_FILE_JPG_EX Lib "QCAP.X86.DLL" (ByVal pFile As Long, ByVal pszFilePathName As String, ByVal nCropX As Long, ByVal nCropY As Long, ByVal nCropW As Long, ByVal nCropH As Long, ByVal nDstW As Long, ByVal nDstH As Long, ByVal nQuality As Long, ByVal bIsAsync As Boolean, ByVal nMilliseconds  As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_MOVE_OSD_FILE_OBJECT Lib "QCAP.X86.DLL" (ByVal pFile As Long, ByVal iOsdNum As Long, ByVal x As Long, ByVal y As Long, ByVal nSequenceStyle As Long, ByVal dLifeTime  As Double ) As ResultOfFunction 
'
Public Declare Function  QCAP_GET_OSD_FILE_TEXT_BOUNDARY Lib "QCAP.X86.DLL" (ByVal pFile As Long, ByVal iOsdNum As Long, ByVal pszString As String, ByVal pszFontFamilyName As String, ByVal nFontStyle As Long, ByVal nFontSize As Long, ByRef pBoundaryWidth As Long, ByRef pBoundaryHeight   As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_GET_OSD_FILE_TEXT_BOUNDARY_W Lib "QCAP.X86.DLL" (ByVal pFile As Long, ByVal iOsdNum As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_OSD_FILE_TEXT Lib "QCAP.X86.DLL" (ByVal pFile As Long, ByVal iOsdNum As Long, ByVal x As Long, ByVal y As Long, ByVal w As Long, ByVal h As Long, ByVal pszString As String, ByVal pszFontFamilyName As String, ByVal nFontStyle As Long, ByVal nFontSize As Long, ByVal dwFontColor As Long, ByVal dwBackgroundColor As Long, ByVal nTransparent As Long, ByVal nTextStartPosX As Long, ByVal nTextStartPosY As Long, ByVal nSequenceStyle As Long, ByVal dLifeTime  As Double ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_OSD_FILE_TEXT_W Lib "QCAP.X86.DLL" (ByVal pFile As Long, ByVal iOsdNum As Long, ByVal x As Long, ByVal y As Long, ByVal w As Long, ByVal h As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_OSD_FILE_TEXT_EX Lib "QCAP.X86.DLL" _
(ByVal pFile As Long, ByVal iOsdNum As Long, ByVal x As Long, ByVal y As Long, ByVal w As Long, ByVal h As Long, ByVal pszString As String, ByVal pszFontFamilyName As String, ByVal nFontStyle As Long, ByVal nFontSize As Long, ByVal dwFontColor As Long, ByVal dwBackgroundColor As Long, ByVal dwBorderColor As Long, ByVal nBorderWidth As Long, ByVal nTransparent As Long, ByVal nTextStartPosX As Long, ByVal nTextStartPosY As Long, ByVal nStringAlignmentStyle As Long, ByVal nSequenceStyle As Long, ByVal dLifeTime  As Double _
 ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_OSD_FILE_TEXT_EX_W Lib "QCAP.X86.DLL" (ByVal pFile As Long, ByVal iOsdNum As Long, ByVal x As Long, ByVal y As Long, ByVal w As Long, ByVal h As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_OSD_FILE_PICTURE Lib "QCAP.X86.DLL" (ByVal pFile As Long, ByVal iOsdNum As Long, ByVal x As Long, ByVal y As Long, ByVal w As Long, ByVal h As Long, ByVal pszFilePathName As String, ByVal nTransparent As Long, ByVal nSequenceStyle As Long, ByVal dLifeTime  As Double ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_OSD_FILE_BUFFER Lib "QCAP.X86.DLL" _
(ByVal pFile As Long, ByVal iOsdNum As Long, ByVal x As Long, ByVal y As Long, ByVal w As Long, ByVal h As Long, ByVal nColorSpaceType As Long, ByVal pFrameBuffer As Long, ByVal nFrameWidth As Long, ByVal nFrameHeight As Long, ByVal nFramePitch As Long, ByVal nTransparent As Long, ByVal dwKeyColor As Long, ByVal nKeyColorThreshold As Long, ByVal nKeyColorBlurLevel As Long, ByVal bKeyColorSpillSuppress As Boolean, ByVal nKeyColorSpillSuppressThreshold As Long, ByVal pMaskBuffer As Long, ByVal nSequenceStyle As Long _
, ByVal dLifeTime  As Double ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_OSD_FILE_BUFFER_EX Lib "QCAP.X86.DLL" _
(ByVal pFile As Long, ByVal iOsdNum As Long, ByVal x As Long, ByVal y As Long, ByVal w As Long, ByVal h As Long, ByVal nColorSpaceType As Long, ByVal pFrameBuffer As Long, ByVal nFrameWidth As Long, ByVal nFrameHeight As Long, ByVal nFramePitch As Long, ByVal nCropX As Long, ByVal nCropY As Long, ByVal nCropW As Long, ByVal nCropH As Long, ByVal dwBorderColor As Long, ByVal nBorderWidth As Long, ByVal nTransparent As Long, ByVal dwKeyColor As Long, ByVal nKeyColorThreshold As Long, ByVal nKeyColorBlurLevel As Long _
, ByVal bKeyColorSpillSuppress As Boolean, ByVal nKeyColorSpillSuppressThreshold As Long, ByVal pMaskBuffer As Long, ByVal nSequenceStyle As Long, ByVal dLifeTime  As Double ) As ResultOfFunction 
'
'QCAP_EXT_API QRESULT QCAP_EXPORT  QCAP_REGISTER_FILE_SNAPSHOT_DONE_CALLBACK( PVOID pFile , PF_FILE_SNAPSHOT_DONE_CALLBACK pCB , PVOID pUserData  );
'
'QCAP_EXT_API QRESULT QCAP_EXPORT  QCAP_REGISTER_FILE_SNAPSHOT_STREAM_CALLBACK( PVOID pFile , PF_FILE_SNAPSHOT_STREAM_CALLBACK pCB , PVOID pUserData  );
'
'QCAP_EXT_API QRESULT QCAP_EXPORT  QCAP_REGISTER_VIDEO_DECODER_FILE_CALLBACK( PVOID pFile , PF_VIDEO_DECODER_FILE_CALLBACK pCB , PVOID pUserData  );
'
'QCAP_EXT_API QRESULT QCAP_EXPORT  QCAP_REGISTER_AUDIO_DECODER_FILE_CALLBACK( PVOID pFile , PF_AUDIO_DECODER_FILE_CALLBACK pCB , PVOID pUserData  );
'
'QCAP_EXT_API QRESULT QCAP_EXPORT  QCAP_REGISTER_VIDEO_DECODER_FILE_CALLBACK_EX( PVOID pFile , PF_VIDEO_DECODER_FILE_CALLBACK_EX pCB , PVOID pUserData  ); ' ONLY FOR QCAP_OPEN_FILE_EX & QCAP_OPEN_TIMESHIFT_FILE_EX
'
'QCAP_EXT_API QRESULT QCAP_EXPORT  QCAP_REGISTER_AUDIO_DECODER_FILE_CALLBACK_EX( PVOID pFile , PF_AUDIO_DECODER_FILE_CALLBACK_EX pCB , PVOID pUserData  ); ' ONLY FOR QCAP_OPEN_FILE_EX & QCAP_OPEN_TIMESHIFT_FILE_EX
'
'QCAP_EXT_API QRESULT QCAP_EXPORT  QCAP_REGISTER_VIDEO_DECODER_3D_FILE_CALLBACK( PVOID pFile , PF_VIDEO_DECODER_3D_FILE_CALLBACK pCB , PVOID pUserData  ); ' ONLY FOR QCAP_OPEN_3D_FILE
'
'' FILE EDITING FUNCTIONS ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
'' 
Public Declare Function QCAP_EXPORT_FILE Lib "QCAP.X86.DLL" (ByVal pFile As Long, ByVal dStartSampleTime As Double, ByVal dStopSampleTime As Double, ByVal pszExportedFileName   As String ) As ResultOfFunction 
'
Public Declare Function QCAP_EXPORT_FILE_EX Lib "QCAP.X86.DLL" (ByVal pFile As Long, ByVal pszExportedFileName As String, ByVal nFileArgs As Long, ByVal dStartSampleTime1 As Double, ByVal dStopSampleTime1 As Double, ByVal dStartSampleTime2 As Double, ByVal dStopSampleTime2 As Double ) As ResultOfFunction 
'
Public Declare Function QCAP_EXPORT_FILE_EX_C Lib "QCAP.X86.DLL" (ByVal pFile As Long, ByVal pszExportedFileName As String, ByVal nFileArgs As Long, ByVal dStartSampleTimes  As Double, ByVal dStopSampleTimes    As Double ) As ResultOfFunction 
'
Public Declare Function QCAP_EXPORT_FILES_EX Lib "QCAP.X86.DLL" (ByVal pFile As Long, ByVal nFileArgs As Long, ByVal dStartSampleTime1 As Double, ByVal dStopSampleTime1 As Double, ByVal pszExportedFileName1 As String, ByVal dStartSampleTime2 As Double, ByVal dStopSampleTime2 As Double, ByVal pszExportedFileName2 As String ) As ResultOfFunction 
'
Public Declare Function QCAP_EXPORT_FILES_EX_C Lib "QCAP.X86.DLL" (ByVal pFile As Long, ByVal nFileArgs As Long, ByVal dStartSampleTimes  As Double, ByVal dStopSampleTimes  As Double, ByVal pszExportedFileNames    As String ) As ResultOfFunction 
'
Public Declare Function QCAP_MERGE_FILES Lib "QCAP.X86.DLL" (ByVal pszFrontEndFileName As String, ByVal pszBackEndFileName As String, ByVal pszMergedFileName   As String ) As ResultOfFunction 
'
Public Declare Function QCAP_MERGE_FILES_EX Lib "QCAP.X86.DLL" (ByVal pszMergedFileName As String, ByVal nFileArgs As Long, ByVal pszSourceFileName1 As String, ByVal pszSourceFileName2 As String ) As ResultOfFunction 
'
Public Declare Function QCAP_MERGE_FILES_EX_C Lib "QCAP.X86.DLL" (ByVal pszMergedFileName As String, ByVal nFileArgs As Long, ByVal pszSourceFileNames    As String ) As ResultOfFunction 
'
Public Declare Function QCAP_MERGE_FILES_BY_EDL Lib "QCAP.X86.DLL" (ByVal pszEDLFileName   As String ) As ResultOfFunction 
'
Public Declare Function QCAP_BUILD_VIDEO_ON_DEMAND_FILE Lib "QCAP.X86.DLL" (ByVal pszOriginalFileName As String, ByVal pszVideoOnDemandFileName   As String ) As ResultOfFunction 
'
'' FILE REPAIR FUNCTIONS ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
'' 
Public Declare Function QCAP_DIAGNOSE_FILE Lib "QCAP.X86.DLL" (ByVal pszFileName As String, ByRef pIsHealthy   As Boolean ) As ResultOfFunction 
'
Public Declare Function QCAP_REPAIR_FILE Lib "QCAP.X86.DLL" (ByVal pszBadFileName As String, ByVal pszRepairedFileName   As String ) As ResultOfFunction 
'
'' FILE TRANSCODING FUNCTIONS ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
'' 
'typedef QRETURN (QCAP_EXPORT *PF_FILE_TRANSCODER_CALLBACK)( PVOID pFileTranscoder , double dPercentageCompleted , PVOID pUserData  );
'
Public Declare Function QCAP_CREATE_FILE_TRANSCODER Lib "QCAP.X86.DLL" (ByVal pszSrcFileName As String, ByRef ppFileTranscoder As Long, ByVal nDecoderType As Long, ByRef pVideoEncoderFormat As Long, ByRef pVideoWidth As Long, ByRef pVideoHeight As Long, ByRef pVideoFrameRate As Double, ByRef pAudioEncoderFormat As Long, ByRef pAudioChannels As Long, ByRef pAudioBitsPerSample As Long, ByRef pAudioSampleFrequency As Long, ByRef pTotalDurationTimes As Double, ByRef pTotalVideoFrames As Long, ByRef pTotalAudioFrames As Long, ByRef pTotalMetadataFrames   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_DESTROY_FILE_TRANSCODER Lib "QCAP.X86.DLL" (ByVal pFileTranscoder   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_GET_VIDEO_FILE_TRANSCODER_PROPERTY Lib "QCAP.X86.DLL" (ByVal pFileTranscoder As Long, ByRef pEncoderType As Long, ByRef pEncoderFormat As Long, ByRef pWidth As Long, ByRef pHeight As Long, ByRef pFrameRate As Double, ByRef pRecordMode As Long, ByRef pQuality As Long, ByRef pBitRate As Long, ByRef pGOP As Long, ByRef pAspectRatioX As Long, ByRef pAspectRatioY   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_VIDEO_FILE_TRANSCODER_PROPERTY Lib "QCAP.X86.DLL" (ByVal pFileTranscoder As Long, ByVal   nEncoderType As Long, ByVal   nEncoderFormat As Long, ByVal   nWidth As Long, ByVal   nHeight As Long, ByVal   dFrameRate As Double, ByVal   nRecordMode As Long, ByVal   nQuality As Long, ByVal   nBitRate As Long, ByVal   nGOP As Long, ByVal   nAspectRatioX As Long, ByVal   nAspectRatioY    As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_GET_VIDEO_FILE_TRANSCODER_PROPERTY_EX Lib "QCAP.X86.DLL" _
(ByVal pFileTranscoder As Long, ByRef pEncoderType As Long, ByRef pEncoderFormat As Long, ByRef pWidth As Long, ByRef pHeight As Long, ByRef pFrameRate As Double, ByRef pRecordProfile  As Long, ByRef pRecordLevel  As Long, ByRef pRecordEntropy  As Long, ByRef pRecordComplexity  As Long, ByRef pRecordMode As Long, ByRef pQuality As Long, ByRef pBitRate As Long, ByRef pGOP As Long, ByRef pBFrames  As Long, ByRef pIsInterleaved  As Boolean, ByRef pSlices  As Long, ByRef pLayers  As Long, ByRef pSceneCut  As Long _
, ByRef pMultiThread  As Boolean, ByRef pMBBRC  As Boolean, ByRef pExtBRC  As Boolean, ByRef pMinQP  As Long, ByRef pMaxQP  As Long, ByRef pVBVMaxRate  As Long, ByRef pVBVBufSize  As Long, ByRef pCBRVariation  As Long, ByRef pAspectRatioX As Long, ByRef pAspectRatioY   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_VIDEO_FILE_TRANSCODER_PROPERTY_EX Lib "QCAP.X86.DLL" _
(ByVal pFileTranscoder As Long, ByVal   nEncoderType As Long, ByVal   nEncoderFormat As Long, ByVal   nWidth As Long, ByVal   nHeight As Long, ByVal   dFrameRate As Double, ByVal   nRecordProfile   As Long, ByVal   nRecordLevel   As Long, ByVal   nRecordEntropy   As Long, ByVal   nRecordComplexity   As Long, ByVal   nRecordMode As Long, ByVal   nQuality As Long, ByVal   nBitRate As Long, ByVal   nGOP As Long, ByVal   nBFrames   As Long, ByVal   bIsInterleaved   As Boolean, ByVal   nSlices   As Long _
, ByVal   nLayers   As Long, ByVal   nSceneCut   As Long, ByVal   bMultiThread   As Boolean, ByVal   bMBBRC   As Boolean, ByVal   bExtBRC   As Boolean, ByVal   nMinQP   As Long, ByVal   nMaxQP   As Long, ByVal   nVBVMaxRate   As Long, ByVal   nVBVBufSize   As Long, ByVal   nCBRVariation   As Long, ByVal   nAspectRatioX As Long, ByVal   nAspectRatioY    As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_START_FILE_TRANSCODER Lib "QCAP.X86.DLL" (ByVal pFileTranscoder As Long, ByVal pszDstFileName   As String ) As ResultOfFunction 
'
Public Declare Function QCAP_STOP_FILE_TRANSCODER Lib "QCAP.X86.DLL" (ByVal pFileTranscoder   As Long ) As ResultOfFunction 
'
'QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_FILE_TRANSCODER_CALLBACK( PVOID pFileTranscoder , PF_FILE_TRANSCODER_CALLBACK pCB , PVOID pUserData  );
'
'' ##########################################################################################################################################################################################
'' #
'' # ANIMATION FUNCTIONS
'' #
'' ##########################################################################################################################################################################################
''
Public Declare Function QCAP_CREATE_ANIMATION_CLIP Lib "QCAP.X86.DLL" (ByVal pszAniFileName As String, ByRef ppClip As Long, ByRef pTotalFrames As Long, ByRef pTotalSprites As Long, ByRef pColorSpaceType As Long, ByRef pWidth As Long, ByRef pHeight   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_DESTROY_ANIMATION_CLIP Lib "QCAP.X86.DLL" (ByVal pClip   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_START_ANIMATION_CLIP Lib "QCAP.X86.DLL" (ByVal pClip   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_STOP_ANIMATION_CLIP Lib "QCAP.X86.DLL" (ByVal pClip   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_STEP_ANIMATION_CLIP Lib "QCAP.X86.DLL" (ByVal pClip As Long, ByRef pFrameNum As Long, ByRef ppFrameBuffer As Long, ByRef pFrameBufferLen As Long, ByVal bClearBackground  As Boolean ) As ResultOfFunction 
'
Public Declare Function QCAP_SEEK_ANIMATION_CLIP Lib "QCAP.X86.DLL" (ByVal pClip As Long, ByVal iFrameNum As Long, ByRef ppFrameBuffer As Long, ByRef pFrameBufferLen As Long, ByVal bClearBackground  As Boolean ) As ResultOfFunction 
'
Public Declare Function QCAP_GET_ANIMATION_CLIP_SPRITE_TRANSFORM_PROPERTY Lib "QCAP.X86.DLL" (ByVal pClip As Long, ByVal iSpriteNum As Long, ByVal iFrameNum As Long, ByRef pPositionX As Long, ByRef pPositionY As Long, ByRef pScaleW As Long, ByRef pScaleH   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_ANIMATION_CLIP_SPRITE_TRANSFORM_PROPERTY Lib "QCAP.X86.DLL" (ByVal pClip As Long, ByVal iSpriteNum As Long, ByVal iFrameNum As Long, ByVal nPositionX As Long, ByVal nPositionY As Long, ByVal nScaleW As Long, ByVal nScaleH   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_GET_ANIMATION_CLIP_SPRITE_ALPHA_PROPERTY Lib "QCAP.X86.DLL" (ByVal pClip As Long, ByVal iSpriteNum As Long, ByVal iFrameNum As Long, ByRef pAlpha   As Double ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_ANIMATION_CLIP_SPRITE_ALPHA_PROPERTY Lib "QCAP.X86.DLL" (ByVal pClip As Long, ByVal iSpriteNum As Long, ByVal iFrameNum As Long, ByVal nAlpha   As Double ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_ANIMATION_CLIP_SPRITE_PICTURE Lib "QCAP.X86.DLL" (ByVal pClip As Long, ByVal iSpriteNum As Long, ByVal pszFilePathName   As String ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_ANIMATION_CLIP_SPRITE_BUFFER Lib "QCAP.X86.DLL" (ByVal pClip As Long, ByVal iSpriteNum As Long, ByVal nColorSpaceType As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long, ByVal bCloneCopy  As Boolean ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_ANIMATION_CLIP_SPRITE_BUFFER_EX Lib "QCAP.X86.DLL" (ByVal pClip As Long, ByVal iSpriteNum As Long, ByVal nColorSpaceType As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long, ByVal nCropX As Long, ByVal nCropY As Long, ByVal nCropW As Long, ByVal nCropH As Long, ByVal bCloneCopy  As Boolean ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_ANIMATION_CLIP_SPRITE_SOURCE Lib "QCAP.X86.DLL" (ByVal pClip As Long, ByVal iSpriteNum As Long, ByVal pDevice As Long, ByVal nSequenceStyle As Long, ByVal bCloneCopy  As Boolean ) As ResultOfFunction 
'
Public Declare Function QCAP_SET_ANIMATION_CLIP_SPRITE_SOURCE_EX Lib "QCAP.X86.DLL" (ByVal pClip As Long, ByVal iSpriteNum As Long, ByVal pDevice As Long, ByVal nCropX As Long, ByVal nCropY As Long, ByVal nCropW As Long, ByVal nCropH As Long, ByVal nSequenceStyle As Long, ByVal bCloneCopy  As Boolean ) As ResultOfFunction 
'
'' ANIMATION EXAMPLE:
''
'' STEP#01 QCAP_CREATE_ANIMATION_CLIP( "EXAMPLE.FADEOUT.XML", &pClip, &nFrames, &nSprites, &nColorSpaceType, &nWidth, &nHeight );
''
'' STEP#02 QCAP_START_ANIMATION_CLIP( pClip );
''
'' STEP#03 QCAP_SET_ANIMATION_CLIP_SPRITE_BUFFER( pClip, 0 , QCAP_COLORSPACE_TYEP_YUY2, 1920, 1080, pFrameBufferA, nFrameBufferLenA );
'' 
''         QCAP_SET_ANIMATION_CLIP_SPRITE_SOURCE( pClip, 1 , QCAP_COLORSPACE_TYEP_YUY2, 1920, 1080, pFrameBufferB, nFrameBufferLenB );
''
'' STEP#04 QCAP_STEP_ANIMATION_CLIP( pClip, &iFrameNum, &pFrameBuffer, &nFrameBufferLen, TRUE );
''
'' STEP#05 QCAP_STOP_ANIMATION_CLIP( pClip );
''
'' STEP#06 QCAP_DESTROY_ANIMATION_CLIP( pClip );
'
'' ##########################################################################################################################################################################################
'' #
'' # VIRTUAL CAMERA FUNCTIONS
'' #
'' ##########################################################################################################################################################################################
''
'typedef QRETURN (QCAP_EXPORT *PF_VIRTUAL_CAMERA_SNAPSHOT_DONE_CALLBACK)( PVOID pCamera , CHAR * pszFilePathName , PVOID pUserData  );
'
'typedef QRETURN (QCAP_EXPORT *PF_VIRTUAL_CAMERA_SNAPSHOT_STREAM_CALLBACK)( PVOID pCamera , CHAR * pszFilePathName , BYTE * pStreamBuffer , ULONG nStreamBufferLen , PVOID pUserData  );
'
Public Declare Function  QCAP_CREATE_VIRTUAL_CAMERA Lib "QCAP.X86.DLL" (ByVal iCamNum  As Long, ByRef ppCamera   As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_DESTROY_VIRTUAL_CAMERA Lib "QCAP.X86.DLL" (ByVal pCamera   As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_GET_VIDEO_VIRTUAL_CAMERA_PROPERTY Lib "QCAP.X86.DLL" (ByVal pCamera As Long, ByRef pColorSpaceType As Long, ByRef pWidth As Long, ByRef pHeight As Long, ByRef pFrameRate   As Double ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_VIDEO_VIRTUAL_CAMERA_PROPERTY Lib "QCAP.X86.DLL" (ByVal pCamera As Long, ByVal   nColorSpaceType As Long, ByVal   nWidth As Long, ByVal   nHeight As Long, ByVal   dFrameRate    As Double ) As ResultOfFunction 
'
Public Declare Function  QCAP_GET_AUDIO_VIRTUAL_CAMERA_PROPERTY Lib "QCAP.X86.DLL" (ByVal pCamera As Long, ByRef pChannels As Long, ByRef pBitsPerSample As Long, ByRef pSampleFrequency   As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_AUDIO_VIRTUAL_CAMERA_PROPERTY Lib "QCAP.X86.DLL" (ByVal pCamera As Long, ByVal   nChannels As Long, ByVal   nBitsPerSample As Long, ByVal   nSampleFrequency    As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_VIDEO_VIRTUAL_CAMERA_UNCOMPRESSION_BUFFER Lib "QCAP.X86.DLL" (ByVal pCamera As Long, ByVal nColorSpaceType As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long, ByVal dSampleTime  As Double ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_VIDEO_VIRTUAL_CAMERA_UNCOMPRESSION_BUFFER_EX Lib "QCAP.X86.DLL" (ByVal pCamera As Long, ByVal nColorSpaceType As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long, ByVal nCropX As Long, ByVal nCropY As Long, ByVal nCropW As Long, ByVal nCropH As Long, ByVal nScaleStyle As Long, ByVal dSampleTime  As Double ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_AUDIO_VIRTUAL_CAMERA_UNCOMPRESSION_BUFFER Lib "QCAP.X86.DLL" (ByVal pCamera As Long, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long, ByVal dSampleTime  As Double ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_AUDIO_VIRTUAL_CAMERA_UNCOMPRESSION_BUFFER_EX Lib "QCAP.X86.DLL" (ByVal pCamera As Long, ByVal nChannels As Long, ByVal nBitsPerSample As Long, ByVal nSampleFrequency As Long, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long, ByVal dSampleTime  As Double ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_AUDIO_MX_VIRTUAL_CAMERA_MIXING_UNCOMPRESSION_BUFFER Lib "QCAP.X86.DLL" (ByVal pCamera As Long, ByVal iMixNum As Long, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen   As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_AUDIO_MX_VIRTUAL_CAMERA_MIXING_UNCOMPRESSION_BUFFER_EX Lib "QCAP.X86.DLL" (ByVal pCamera As Long, ByVal iMixNum As Long, ByVal nChannels As Long, ByVal nBitsPerSample As Long, ByVal nSampleFrequency As Long, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen   As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_AUDIO_MX_VIRTUAL_CAMERA_UNCOMPRESSION_BUFFER Lib "QCAP.X86.DLL" (ByVal pCamera As Long, ByVal dSampleTime  As Double ) As ResultOfFunction 
'
Public Declare Function  QCAP_START_VIRTUAL_CAMERA Lib "QCAP.X86.DLL" (ByVal pCamera   As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_STOP_VIRTUAL_CAMERA Lib "QCAP.X86.DLL" (ByVal pCamera   As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_SNAPSHOT_VIRTUAL_CAMERA_BMP Lib "QCAP.X86.DLL" (ByVal pCamera As Long, ByVal pszFilePathName As String, ByVal bIsAsync As Boolean, ByVal nMilliseconds  As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_SNAPSHOT_VIRTUAL_CAMERA_JPG Lib "QCAP.X86.DLL" (ByVal pCamera As Long, ByVal pszFilePathName As String, ByVal nQuality As Long, ByVal bIsAsync As Boolean, ByVal nMilliseconds  As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_SNAPSHOT_VIRTUAL_CAMERA_BMP_EX Lib "QCAP.X86.DLL" (ByVal pCamera As Long, ByVal pszFilePathName As String, ByVal nCropX As Long, ByVal nCropY As Long, ByVal nCropW As Long, ByVal nCropH As Long, ByVal nDstW As Long, ByVal nDstH As Long, ByVal bIsAsync As Boolean, ByVal nMilliseconds  As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_SNAPSHOT_VIRTUAL_CAMERA_JPG_EX Lib "QCAP.X86.DLL" (ByVal pCamera As Long, ByVal pszFilePathName As String, ByVal nCropX As Long, ByVal nCropY As Long, ByVal nCropW As Long, ByVal nCropH As Long, ByVal nDstW As Long, ByVal nDstH As Long, ByVal nQuality As Long, ByVal bIsAsync As Boolean, ByVal nMilliseconds  As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_MOVE_OSD_VIRTUAL_CAMERA_OBJECT Lib "QCAP.X86.DLL" (ByVal pCamera As Long, ByVal iOsdNum As Long, ByVal x As Long, ByVal y As Long, ByVal nSequenceStyle As Long, ByVal dLifeTime  As Double ) As ResultOfFunction 
'
Public Declare Function  QCAP_GET_OSD_VIRTUAL_CAMERA_TEXT_BOUNDARY Lib "QCAP.X86.DLL" (ByVal pCamera As Long, ByVal iOsdNum As Long, ByVal pszString As String, ByVal pszFontFamilyName As String, ByVal nFontStyle As Long, ByVal nFontSize As Long, ByRef pBoundaryWidth As Long, ByRef pBoundaryHeight   As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_GET_OSD_VIRTUAL_CAMERA_TEXT_BOUNDARY_W Lib "QCAP.X86.DLL" (ByVal pCamera As Long, ByVal iOsdNum As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_OSD_VIRTUAL_CAMERA_TEXT Lib "QCAP.X86.DLL" (ByVal pCamera As Long, ByVal iOsdNum As Long, ByVal x As Long, ByVal y As Long, ByVal w As Long, ByVal h As Long, ByVal pszString As String, ByVal pszFontFamilyName As String, ByVal nFontStyle As Long, ByVal nFontSize As Long, ByVal dwFontColor As Long, ByVal dwBackgroundColor As Long, ByVal nTransparent As Long, ByVal nTextStartPosX As Long, ByVal nTextStartPosY As Long, ByVal nSequenceStyle As Long, ByVal dLifeTime  As Double ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_OSD_VIRTUAL_CAMERA_TEXT_W Lib "QCAP.X86.DLL" (ByVal pCamera As Long, ByVal iOsdNum As Long, ByVal x As Long, ByVal y As Long, ByVal w As Long, ByVal h As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_OSD_VIRTUAL_CAMERA_TEXT_EX Lib "QCAP.X86.DLL" _
(ByVal pCamera As Long, ByVal iOsdNum As Long, ByVal x As Long, ByVal y As Long, ByVal w As Long, ByVal h As Long, ByVal pszString As String, ByVal pszFontFamilyName As String, ByVal nFontStyle As Long, ByVal nFontSize As Long, ByVal dwFontColor As Long, ByVal dwBackgroundColor As Long, ByVal dwBorderColor As Long, ByVal nBorderWidth As Long, ByVal nTransparent As Long, ByVal nTextStartPosX As Long, ByVal nTextStartPosY As Long, ByVal nStringAlignmentStyle As Long, ByVal nSequenceStyle As Long, ByVal dLifeTime  As Double _
 ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_OSD_VIRTUAL_CAMERA_TEXT_EX_W Lib "QCAP.X86.DLL" (ByVal pCamera As Long, ByVal iOsdNum As Long, ByVal x As Long, ByVal y As Long, ByVal w As Long, ByVal h As Long ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_OSD_VIRTUAL_CAMERA_PICTURE Lib "QCAP.X86.DLL" (ByVal pCamera As Long, ByVal iOsdNum As Long, ByVal x As Long, ByVal y As Long, ByVal w As Long, ByVal h As Long, ByVal pszFilePathName As String, ByVal nTransparent As Long, ByVal nSequenceStyle As Long, ByVal dLifeTime  As Double ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_OSD_VIRTUAL_CAMERA_BUFFER Lib "QCAP.X86.DLL" _
(ByVal pCamera As Long, ByVal iOsdNum As Long, ByVal x As Long, ByVal y As Long, ByVal w As Long, ByVal h As Long, ByVal nColorSpaceType As Long, ByVal pFrameBuffer As Long, ByVal nFrameWidth As Long, ByVal nFrameHeight As Long, ByVal nFramePitch As Long, ByVal nTransparent As Long, ByVal dwKeyColor As Long, ByVal nKeyColorThreshold As Long, ByVal nKeyColorBlurLevel As Long, ByVal bKeyColorSpillSuppress As Boolean, ByVal nKeyColorSpillSuppressThreshold As Long, ByVal pMaskBuffer As Long, ByVal nSequenceStyle As Long _
, ByVal dLifeTime  As Double ) As ResultOfFunction 
'
Public Declare Function  QCAP_SET_OSD_VIRTUAL_CAMERA_BUFFER_EX Lib "QCAP.X86.DLL" _
(ByVal pCamera As Long, ByVal iOsdNum As Long, ByVal x As Long, ByVal y As Long, ByVal w As Long, ByVal h As Long, ByVal nColorSpaceType As Long, ByVal pFrameBuffer As Long, ByVal nFrameWidth As Long, ByVal nFrameHeight As Long, ByVal nFramePitch As Long, ByVal nCropX As Long, ByVal nCropY As Long, ByVal nCropW As Long, ByVal nCropH As Long, ByVal dwBorderColor As Long, ByVal nBorderWidth As Long, ByVal nTransparent As Long, ByVal dwKeyColor As Long, ByVal nKeyColorThreshold As Long, ByVal nKeyColorBlurLevel As Long _
, ByVal bKeyColorSpillSuppress As Boolean, ByVal nKeyColorSpillSuppressThreshold As Long, ByVal pMaskBuffer As Long, ByVal nSequenceStyle As Long, ByVal dLifeTime  As Double ) As ResultOfFunction 
'
'QCAP_EXT_API QRESULT QCAP_EXPORT  QCAP_REGISTER_VIRTUAL_CAMERA_SNAPSHOT_DONE_CALLBACK( PVOID pCamera , PF_VIRTUAL_CAMERA_SNAPSHOT_DONE_CALLBACK pCB , PVOID pUserData  );
'
'QCAP_EXT_API QRESULT QCAP_EXPORT  QCAP_REGISTER_VIRTUAL_CAMERA_SNAPSHOT_STREAM_CALLBACK( PVOID pCamera , PF_VIRTUAL_CAMERA_SNAPSHOT_STREAM_CALLBACK pCB , PVOID pUserData  );
'
'' ##########################################################################################################################################################################################
'' #
'' # SERIAL PORT I/O FUNCTIONS (RS232/RS485)
'' #
'' ##########################################################################################################################################################################################
''
'typedef QRETURN (QCAP_EXPORT *PF_SERIAL_PORT_RECEIVED_DATA_CALLBACK)( PVOID pPort , UINT iPortNum , BYTE * pDataBuffer , ULONG nDataBufferLen , PVOID pUserData  );
'
Public Declare Function QCAP_SERIAL_PORT_ENUMERATION Lib "QCAP.X86.DLL" (ByRef pAvailablePortNum As Long, ByVal bNext  As Boolean ) As ResultOfFunction 
'
Public Declare Function QCAP_CREATE_SERIAL_PORT Lib "QCAP.X86.DLL" (ByVal iPortNum As Long, ByRef ppPort As Long, ByVal nBaudRate As Long, ByVal nDataBits As Long, ByVal nParityCheck As Long, ByVal nStopBits As Long, ByVal nFlowControl As Long, ByVal bAsynchronousIO  As Boolean ) As ResultOfFunction 
'
Public Declare Function QCAP_DESTROY_SERIAL_PORT Lib "QCAP.X86.DLL" (ByVal pPort   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_START_SERIAL_PORT Lib "QCAP.X86.DLL" (ByVal pPort   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_STOP_SERIAL_PORT Lib "QCAP.X86.DLL" (ByVal pPort   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_SEND_SERIAL_PORT_SIGNAL Lib "QCAP.X86.DLL" (ByVal pPort As Long, ByVal nSignalType   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_SEND_SERIAL_PORT_DATA Lib "QCAP.X86.DLL" (ByVal pPort As Long, ByVal pDataBuffer As Long, ByVal nDataBufferLen   As Long ) As ResultOfFunction 
'
'QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_SERIAL_PORT_RECEIVED_DATA_CALLBACK( PVOID pPort , PF_SERIAL_PORT_RECEIVED_DATA_CALLBACK pCB , PVOID pUserData  );
'
'' ##########################################################################################################################################################################################
'' #
'' # DISC BURNING FUNCTIONS
'' #
'' ##########################################################################################################################################################################################
''
Public Declare Function QCAP_CREATE_BURNING_DRIVE Lib "QCAP.X86.DLL" (ByVal cDriveName As String, ByVal pVolumeName As String, ByRef ppDrive   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_DESTROY_BURNING_DRIVE Lib "QCAP.X86.DLL" (ByVal pDrive   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_START_BURNING_DRIVE Lib "QCAP.X86.DLL" (ByVal pDrive   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_STOP_BURNING_DRIVE Lib "QCAP.X86.DLL" (ByVal pDrive   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_UNLOAD_DISC Lib "QCAP.X86.DLL" (ByVal pDrive   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_LOAD_DISC Lib "QCAP.X86.DLL" (ByVal pDrive   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_GET_DISC_INFO Lib "QCAP.X86.DLL" (ByVal pDrive As Long, ByRef pIsDiscBlank As Boolean, ByRef pIsDiscWriteable As Boolean, ByRef pDiscType As Long, ByVal pDiscRemainCapability   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_ERASE_DISC Lib "QCAP.X86.DLL" (ByVal pDrive   As Long ) As ResultOfFunction 
'
'' BURNING EXAMPLE:
'' 
'' STEP#01 QCAP_CREATE_BURNING_DRIVE( 'E', "TEST", &pDrive );
''
'' STEP#02 QCAP_START_BURNING_DRIVE( pDrive );
'' 
'' STEP#03 QCAP_START_RECORD( pDevice, 0, "E:\\CH01.TS" );
'' 
'' STEP#04 QCAP_STOP_RECORD( pDevice, 0, FALSE, INFINE ); // NOTE!! WAITIING FILE CLOSE
'' 
'' STEP#05 QCAP_STOP_BURNING_DRIVE( pDrive );
'' 
'' STEP#06 QCAP_UNLOAD_DISC( pDrive );
'' 
'' STEP#07 QCAP_DESTROY_BURNING_DRIVE( pDrive );
'
'' ##########################################################################################################################################################################################
'' #
'' # MEDIA TIMER FUNCTIONS (HIGH PRECISION)
'' #
'' ##########################################################################################################################################################################################
''
'typedef QRETURN (QCAP_EXPORT *PF_MEDIA_TIMER_CALLBACK)( PVOID pTimer , double dSampleTime , double dDelayTime , PVOID pUserData  );
'
Public Declare Function QCAP_CREATE_MEDIA_TIMER Lib "QCAP.X86.DLL" (ByVal nElapseTimeNum As Long, ByVal nElapseTimeDeno As Long, ByRef ppTimer   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_DESTROY_MEDIA_TIMER Lib "QCAP.X86.DLL" (ByVal pTimer   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_START_MEDIA_TIMER Lib "QCAP.X86.DLL" (ByVal pTimer   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_STOP_MEDIA_TIMER Lib "QCAP.X86.DLL" (ByVal pTimer   As Long ) As ResultOfFunction 
'
'QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_MEDIA_TIMER_CALLBACK( PVOID pTimer , PF_MEDIA_TIMER_CALLBACK pCB , PVOID pUserData  );
'
'' ##########################################################################################################################################################################################
'' #
'' # HELPER FUNCTIONS (ENCODER/VIDEO/AUDIO/DEVELOPER)
'' #
'' ##########################################################################################################################################################################################
''
'' HELPER FUNCTIONS PART.1 (FOR ENCODER) ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
'' 
Public Declare Function QCAP_GET_H264_BUFFER_LAYER_ID Lib "QCAP.X86.DLL" (ByVal pStreamBuffer As Long, ByVal nStreamBufferLen As Long, ByRef pLayerID   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_GET_H264_BUFFER_COLOR_INFO Lib "QCAP.X86.DLL" (ByVal pStreamBuffer As Long, ByVal nStreamBufferLen As Long, ByRef pColorRangeType   As Long ) As ResultOfFunction 
'
'' HELPER FUNCTIONS PART.2 (FOR VIDEO) //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
'' 
Public Declare Function QCAP_COLORSPACE_YUY2_TO_ABGR32 Lib "QCAP.X86.DLL" (ByVal pSrcFrameBuffer As Long, ByVal nSrcWidth As Long, ByVal nSrcHeight As Long, ByVal nSrcPitch As Long, ByVal pDstFrameBuffer As Long, ByVal nDstWidth As Long, ByVal nDstHeight As Long, ByVal nDstPitch As Long, ByVal bAlpah As Long, ByVal bHorizontalMirror As Boolean, ByVal bVerticalMirror  As Boolean ) As ResultOfFunction 
'
Public Declare Function QCAP_COLORSPACE_YV12_TO_ABGR32 Lib "QCAP.X86.DLL" (ByVal pSrcFrameBuffer As Long, ByVal nSrcWidth As Long, ByVal nSrcHeight As Long, ByVal nSrcPitch As Long, ByVal pDstFrameBuffer As Long, ByVal nDstWidth As Long, ByVal nDstHeight As Long, ByVal nDstPitch As Long, ByVal bAlpah As Long, ByVal bHorizontalMirror As Boolean, ByVal bVerticalMirror  As Boolean ) As ResultOfFunction 
'
Public Declare Function QCAP_COLORSPACE_YUY2_TO_ARGB32 Lib "QCAP.X86.DLL" (ByVal pSrcFrameBuffer As Long, ByVal nSrcWidth As Long, ByVal nSrcHeight As Long, ByVal nSrcPitch As Long, ByVal pDstFrameBuffer As Long, ByVal nDstWidth As Long, ByVal nDstHeight As Long, ByVal nDstPitch As Long, ByVal bAlpah As Long, ByVal bHorizontalMirror As Boolean, ByVal bVerticalMirror  As Boolean ) As ResultOfFunction 
'
Public Declare Function QCAP_COLORSPACE_YV12_TO_ARGB32 Lib "QCAP.X86.DLL" (ByVal pSrcFrameBuffer As Long, ByVal nSrcWidth As Long, ByVal nSrcHeight As Long, ByVal nSrcPitch As Long, ByVal pDstFrameBuffer As Long, ByVal nDstWidth As Long, ByVal nDstHeight As Long, ByVal nDstPitch As Long, ByVal bAlpah As Long, ByVal bHorizontalMirror As Boolean, ByVal bVerticalMirror  As Boolean ) As ResultOfFunction 
'
Public Declare Function QCAP_COLORSPACE_YUY2_TO_BGR24 Lib "QCAP.X86.DLL" (ByVal pSrcFrameBuffer As Long, ByVal nSrcWidth As Long, ByVal nSrcHeight As Long, ByVal nSrcPitch As Long, ByVal pDstFrameBuffer As Long, ByVal nDstWidth As Long, ByVal nDstHeight As Long, ByVal nDstPitch As Long, ByVal bHorizontalMirror As Boolean, ByVal bVerticalMirror  As Boolean ) As ResultOfFunction 
'
Public Declare Function QCAP_COLORSPACE_YV12_TO_BGR24 Lib "QCAP.X86.DLL" (ByVal pSrcFrameBuffer As Long, ByVal nSrcWidth As Long, ByVal nSrcHeight As Long, ByVal nSrcPitch As Long, ByVal pDstFrameBuffer As Long, ByVal nDstWidth As Long, ByVal nDstHeight As Long, ByVal nDstPitch As Long, ByVal bHorizontalMirror As Boolean, ByVal bVerticalMirror  As Boolean ) As ResultOfFunction 
'
Public Declare Function QCAP_COLORSPACE_YUY2_TO_RGB24 Lib "QCAP.X86.DLL" (ByVal pSrcFrameBuffer As Long, ByVal nSrcWidth As Long, ByVal nSrcHeight As Long, ByVal nSrcPitch As Long, ByVal pDstFrameBuffer As Long, ByVal nDstWidth As Long, ByVal nDstHeight As Long, ByVal nDstPitch As Long, ByVal bHorizontalMirror As Boolean, ByVal bVerticalMirror  As Boolean ) As ResultOfFunction 
'
Public Declare Function QCAP_COLORSPACE_YV12_TO_RGB24 Lib "QCAP.X86.DLL" (ByVal pSrcFrameBuffer As Long, ByVal nSrcWidth As Long, ByVal nSrcHeight As Long, ByVal nSrcPitch As Long, ByVal pDstFrameBuffer As Long, ByVal nDstWidth As Long, ByVal nDstHeight As Long, ByVal nDstPitch As Long, ByVal bHorizontalMirror As Boolean, ByVal bVerticalMirror  As Boolean ) As ResultOfFunction 
'
Public Declare Function QCAP_COLORSPACE_YUY2_TO_YV12 Lib "QCAP.X86.DLL" (ByVal pSrcFrameBuffer As Long, ByVal nSrcWidth As Long, ByVal nSrcHeight As Long, ByVal nSrcPitch As Long, ByVal pDstFrameBuffer As Long, ByVal nDstWidth As Long, ByVal nDstHeight As Long, ByVal nDstPitch As Long, ByVal bHorizontalMirror As Boolean, ByVal bVerticalMirror  As Boolean ) As ResultOfFunction 
'
Public Declare Function QCAP_COLORSPACE_YV12_TO_YUY2 Lib "QCAP.X86.DLL" (ByVal pSrcFrameBuffer As Long, ByVal nSrcWidth As Long, ByVal nSrcHeight As Long, ByVal nSrcPitch As Long, ByVal pDstFrameBuffer As Long, ByVal nDstWidth As Long, ByVal nDstHeight As Long, ByVal nDstPitch As Long, ByVal bHorizontalMirror As Boolean, ByVal bVerticalMirror  As Boolean ) As ResultOfFunction 
'
Public Declare Function QCAP_SNAPSHOT_BUFFER_TO_BMP_EX Lib "QCAP.X86.DLL" (ByVal pszFilePathName As String, ByVal nColorSpaceType As Long, ByVal pSrcFrameBuffer As Long, ByVal nSrcWidth As Long, ByVal nSrcHeight As Long, ByVal nSrcPitch As Long, ByVal nCropX As Long, ByVal nCropY As Long, ByVal nCropW As Long, ByVal nCropH As Long, ByVal nDstW As Long, ByVal nDstH As Long, ByVal bIsAsync As Boolean, ByVal nMilliseconds As Long, ByVal pszDstStreamBuffer As Long, ByRef pDstStreamBufferSize  As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_SNAPSHOT_BUFFER_TO_JPG_EX Lib "QCAP.X86.DLL" (ByVal pszFilePathName As String, ByVal nColorSpaceType As Long, ByVal pSrcFrameBuffer As Long, ByVal nSrcWidth As Long, ByVal nSrcHeight As Long, ByVal nSrcPitch As Long, ByVal nCropX As Long, ByVal nCropY As Long, ByVal nCropW As Long, ByVal nCropH As Long, ByVal nDstW As Long, ByVal nDstH As Long, ByVal nQuality As Long, ByVal bIsAsync As Boolean, ByVal nMilliseconds As Long, ByVal pszDstStreamBuffer As Long, ByRef pDstStreamBufferSize  As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_CONVERT_3D_STEREO_BUFFER Lib "QCAP.X86.DLL" (ByVal nColorSpaceType As Long, ByVal nSrcStereoDisplayMode As Long, ByVal pSrcFrameBuffer As Long, ByVal nSrcWidth As Long, ByVal nSrcHeight As Long, ByVal nSrcPitch As Long, ByVal nDstStereoDisplayMode As Long, ByVal pDstFrameBuffer As Long, ByVal nDstWidth As Long, ByVal nDstHeight As Long, ByVal nDstPitch As Long, ByVal bLeftRightSwap  As Boolean ) As ResultOfFunction 
'
Public Declare Function QCAP_RESIZE_VIDEO_BUFFER Lib "QCAP.X86.DLL" (ByVal nColorSpaceType As Long, ByVal pSrcFrameBuffer As Long, ByVal nSrcWidth As Long, ByVal nSrcHeight As Long, ByVal nSrcPitch As Long, ByVal pDstFrameBuffer As Long, ByVal nDstWidth As Long, ByVal nDstHeight As Long, ByVal nDstPitch   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_RESIZE_VIDEO_BUFFER_TO_QDEEP_32F Lib "QCAP.X86.DLL" (ByVal nSrcColorSpaceType As Long, ByVal pSrcFrameBuffer As Long, ByVal nSrcWidth As Long, ByVal nSrcHeight As Long, ByVal nSrcPitch As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_GET_ROTATE_VIDEO_BUFFER_BOUNDARY Lib "QCAP.X86.DLL" (ByVal nSrcWidth As Long, ByVal nSrcHeight As Long, ByRef pDstWidth As Long, ByRef pDstHeight As Long, ByVal dAngle   As Double ) As ResultOfFunction 
'
Public Declare Function QCAP_ROTATE_VIDEO_BUFFER Lib "QCAP.X86.DLL" (ByVal nColorSpaceType As Long, ByVal pSrcFrameBuffer As Long, ByVal nSrcWidth As Long, ByVal nSrcHeight As Long, ByVal nSrcPitch As Long, ByVal pDstFrameBuffer As Long, ByVal nDstWidth As Long, ByVal nDstHeight As Long, ByVal nDstPitch As Long, ByVal dAngle As Double, ByVal pSrcTempFrameBuffer As Long, ByVal pDstTempFrameBuffer As Long, ByVal bClearBackground  As Boolean ) As ResultOfFunction 
'
Public Declare Function QCAP_WARP_VIDEO_BUFFER Lib "QCAP.X86.DLL" (ByVal nColorSpaceType As Long, ByVal pSrcFrameBuffer As Long, ByVal nSrcWidth As Long, ByVal nSrcHeight As Long, ByVal nSrcPitch As Long, ByVal pDstFrameBuffer As Long, ByVal nDstWidth As Long, ByVal nDstHeight As Long, ByVal nDstPitch As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_LOAD_PICTURE_BUFFER Lib "QCAP.X86.DLL" (ByVal pszFilePathName As String, ByRef pColorSpaceType As Long, ByVal pFrameBuffer As Long, ByRef pFrameBufferSize As Long, ByRef pFrameWidth As Long, ByRef pFrameHeight As Long, ByRef pFramePitch   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_CALCULATE_CHROMAKEY Lib "QCAP.X86.DLL" _
(ByVal nColorSpaceType As Long, ByVal pSrcFrameBuffer As Long, ByVal nSrcWidth As Long, ByVal nSrcHeight As Long, ByVal nSrcPitch As Long, ByVal nSrcCropX As Long, ByVal nSrcCropY As Long, ByVal nSrcCropW As Long, ByVal nSrcCropH As Long, ByVal pDstAlpahBuffer As Long, ByVal pDstYBuffer As Long, ByVal pDstCbBuffer As Long, ByVal pDstCrBuffer As Long, ByVal nDstWidth As Long, ByVal nDstHeight As Long, ByVal nDstPitch As Long, ByVal nTransparent As Long, ByVal dwKeyColor As Long, ByVal nKeyColorThreshold As Long _
, ByVal nKeyColorBlurLevel As Long, ByVal bKeyColorSpillSuppress As Boolean, ByVal nKeyColorSpillSuppressThreshold  As Long ) As ResultOfFunction 
'
'' HELPER FUNCTIONS PART.3 (FOR AUDIO) //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
'' 
Public Declare Function QCAP_GET_AUDIO_BUFFER_VOLUME_DB Lib "QCAP.X86.DLL" (ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long, ByVal nChannels As Long, ByVal nBitsPerSample As Long, ByVal nSampleFrequency As Long, ByVal iChNum As Long, ByRef pVolumeDB    As Double ) As ResultOfFunction 
'
Public Declare Function QCAP_GET_AUDIO_BUFFER_FAST_FOURIER_TRANSFORM_DATA Lib "QCAP.X86.DLL" (ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long, ByVal nChannels As Long, ByVal nBitsPerSample As Long, ByVal nSampleFrequency As Long, ByVal iChNum As Long, ByRef pPeakFrq As Double, ByRef pPeakFrqAmp   As Double ) As ResultOfFunction 
'
Public Declare Function QCAP_RESAMPLE_AUDIO_BUFFER Lib "QCAP.X86.DLL" (ByVal pSrcFrameBuffer As Long, ByVal nSrcFrameBufferLen As Long, ByVal nSrcChannels As Long, ByVal nSrcBitsPerSample As Long, ByVal nSrcSampleFrequency As Long, ByVal pDstFrameBuffer As Long, ByRef pDstFrameBufferLen As Long, ByVal nDstChannels As Long, ByVal nDstBitsPerSample As Long, ByVal nDstSampleFrequency   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_RESCALE_AUDIO_BUFFER Lib "QCAP.X86.DLL" (ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long, ByVal nChannels As Long, ByVal nBitsPerSample As Long, ByVal nSampleFrequency As Long, ByVal nVolume   As Long ) As ResultOfFunction 
'
Public Declare Function QCAP_SOUNDRENDERER_ENUMERATION Lib "QCAP.X86.DLL" (ByRef ppszSoundRendererDevName As String, ByVal bNext  As Boolean ) As ResultOfFunction 
'
Public Declare Function QCAP_SOUNDRENDERER_ENUMERATION_W Lib "QCAP.X86.DLL" QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SOUNDRENDERER_ENUMERATION_W( WSTRING * ppwszSoundRendererDevName , BOOL bNext = FALSE  ); ) As ResultOfFunction 
'
